function [ u ] = Poisson2Dsolver(source2D, bdry2D, mesh_number)
% this Matlable code is to solve 2D Poisson equations with Dirichlet
% Boundary conditions on [0,1]x[0,1]
% -\triangle u = f
% Date: October 12, 2013
% version: 1

clc
format long

%mesh generation
mesh_size=1/(mesh_number);
[x y]=meshgrid(0:mesh_size:1, 0:mesh_size:1);

%boundary condiitons
u(1:mesh_number+1, 1:mesh_number+1)=0;
u(1,1:mesh_number+1)=bdry2D(0,0:mesh_size:1);
u(mesh_number+1, 1:mesh_number+1)=bdry2D(1,0:mesh_size:1);
u(1:mesh_number+1, 1)=bdry2D(0:mesh_size:1,0);
u(1:mesh_number+1, mesh_number+1)=bdry2D(0:mesh_size:1,1);
 
%Matrix Formulation
A1D=spdiags(ones(mesh_number-1,1)*[1 -2 1],-1:1,mesh_number-1,mesh_number-1);
I1D = speye(size(A1D));                       % 1d identity matrix
A2D = kron(A1D,I1D)+kron(I1D,A1D); 

%right-hand-side
b1= -mesh_size^2*source2D(x(2:mesh_number, 2:mesh_number),y(2:mesh_number, 2:mesh_number) );

b1(1:mesh_number-1,1)= b1(1:mesh_number-1,1)-u(2:mesh_number, 1);
b1(1:mesh_number-1,mesh_number-1)= b1(1:mesh_number-1,mesh_number-1)-u(2:mesh_number, mesh_number+1);
b1(1,1:mesh_number-1)= b1(1,1:mesh_number-1)-u(1,2:mesh_number);
b1(mesh_number-1, 1:mesh_number-1)= b1(mesh_number-1, 1:mesh_number-1)-u(mesh_number+1, 2:mesh_number);
b=reshape(b1,(mesh_number-1)*(mesh_number-1),1);

%solve u
uu=A2D\b;
u(2:mesh_number, 2:mesh_number)=reshape(uu,mesh_number-1,mesh_number-1);

%visulaize the graph of u
surf(x,y,u)
title('Numerical solution to 2D Poission equation');

figure;
surf(x,y, abs(u-bdry2D(x,y)))



end

