%cameraman 256*256 tilde_dt use 1/512 -> 4000 steps tilde_lambda use 0.05
%alley 256*383*3 tilde_dt use 1/512 -> 4000 steps tilde_lambda use 0.05
%square 256*256 tilde_dt use 1/512 -> 4000 steps tilde_lambda use 0.05
%Einstein 340*340 tilde_dt use 1/680 -> 7000 steps tilde_lambda use 0.01
%Lena 512*512 tilde_dt use 1/1024 -> 10000 steps tilde_lambda use 0.01
%it take a lot of time, so try to use tilde_dt = 1/100 = 0.01 and 1000 steps
%Note that tilde_dt = 1/100, convergence is not guaranteed for any image

I=imread('cameraman.tif');
%I=imread('alley.jpg');
%I=imread('square.jpg');
%I=imread('Einstein.jpg');
%I=imread('Lena512.png');

figure, imshow(I), title('original');set(gca, 'FontSize', 20);
J = imnoise(I, 'gaussian', 0, 0.005);
figure, imshow(J), title(['noisy (PSNR=', num2str(psnr(J, I)), ')']);set(gca, 'FontSize', 20);
u = ROF_denoise_PDE(J,0.05,0.01,1000);   %you can try different tilde_lambda like 0.1 0.05 0.025 0.01 or try different steps like 500 1000 1500 2000
u=uint8(u);
figure, imshow(u),title(['denoised (PSNR=', num2str(psnr(u, I)), ')']);set(gca, 'FontSize', 20);